//
//  OPKeyPair.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2015-03-19.
//
//

#import <Foundation/Foundation.h>

#import "OPPublicKey.h"
#import "OPPrivateKey.h"

// Supported Algorithms
FOUNDATION_EXPORT NSString * const OPRSAOAEP256KeyAlgorithm; // RSA with sha256
FOUNDATION_EXPORT NSString * const OPRSAOAEPKeyAlgorithm; // RSA with sha1

@class OPSymmetricKey;

@interface OPKeyPair : NSObject

@property (nonatomic, readonly) NSString *kid;
@property (nonatomic, readonly) OPPublicKey *pubKey;
@property (nonatomic, readonly) OPPrivateKey *priKey;

+ (NSArray *)supportedAlgorithms;
+ (OPKeyPair *)generate;
+ (OPKeyPair *)decryptJSON:(NSDictionary *)ciphertext withSymKey:(OPSymmetricKey *)key error:(NSError **)error;
+ (OPKeyPair *)decryptJSON:(NSDictionary *)ciphertext withKeyPair:(OPKeyPair *)keyPair error:(NSError **)error;

- (instancetype)initWithKID:(NSString *)kid;
- (id)initWithJSON:(NSDictionary *)json;

- (NSString *)alg;
- (NSDictionary *)exportAsJSON;

- (NSDictionary *)encrypt:(NSData *)plaintext error:(NSError **)error;
- (NSData *)decrypt:(NSDictionary *)ciphertext error:(NSError **)error;
- (NSDictionary *)encryptedJSONWithSymKey:(OPSymmetricKey *)symmetricKey error:(NSError **)error;

@end
